TITLE 'Boundary Conditions for H and B'		         { exa123.pde }
SELECT     errlim=1e-5     ngrid=1     spectral_colors	
VARIABLES   Az							{ Student Edition }
DEFINITIONS				
   r1=1.0     mu0=4*pi*1e-7     mu   Jz=0			{ Current density }
   Bex=dy(Az)    Bey=-dx(Az)    B=vector( Bex, Bey)    Bm=magnitude(B)
   Hx=Bex/mu     Hy=Bey/mu     H=B/mu     Hm=Bm/mu
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'  mu=mu0
    start (-r1, 0) value(Az)=x+y  arc(center=0,0) angle=360
region 'magnet'  mu=1000*mu0
   start (-r1,0) arc(center=0,0) angle=180 line to close
feature
   start 'interface' (-0.9*r1,0) line to (0.9*r1,0)
PLOTS	
   contour( Hx) painted     contour( Hy) painted
   contour( Bex) painted     contour( Bey) painted
   elevation( Bex) on 'interface' on 'magnet'
   elevation( Bex) on 'interface' on 'domain'
   elevation( Bey) on 'interface' on 'magnet'
   elevation( Bey) on 'interface' on 'domain'
END

